/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.BuildRender;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetExchanger
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetExchanger() {
        super(OurItems.nonStackableItemProperties(), () -> 0, "", Reference.BlockReference.TagReference.WHITELIST_EXCHANGING, Reference.BlockReference.TagReference.BLACKLIST_EXCHANGING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildRender(true);
    }

    public int m_6473_() {
        return 3;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44985_) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44985_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setToolMode(ItemStack tool, ExchangingModes mode) {
        CompoundTag tagCompound = tool.m_41784_();
        tagCompound.m_128359_("mode", mode.toString());
    }

    public static ExchangingModes getToolMode(ItemStack tool) {
        CompoundTag tagCompound = tool.m_41784_();
        return ExchangingModes.getFromName(tagCompound.m_128461_("mode"));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        ExchangingModes mode = GadgetExchanger.getToolMode(stack);
        tooltip.add((Component)TooltipTranslation.GADGET_MODE.componentTranslation(mode == ExchangingModes.SURFACE && GadgetExchanger.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.format(new TranslatableComponent(mode.getTranslationKey()).getString()) : new TranslatableComponent(mode.getTranslationKey())).m_6270_(Styles.AQUA));
        tooltip.add((Component)TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).m_6270_(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        tooltip.add((Component)TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetExchanger.getRangeInBlocks(range, mode.getMode())).m_6270_(Styles.LT_PURPLE));
        tooltip.add((Component)TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetExchanger.getFuzzy(stack))).m_6270_(Styles.GOLD));
        GadgetExchanger.addInformationRayTraceFluid(tooltip, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                InteractionResultHolder<Block> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.m_19089_().m_19077_()) {
                    player.m_5661_((Component)MessageTranslation.INVALID_BLOCK.componentTranslation(((Block)result.m_19095_()).getRegistryName()).m_6270_(Styles.AQUA), true);
                    return super.m_7203_(world, player, hand);
                }
            } else if (player instanceof ServerPlayer) {
                this.exchange((ServerPlayer)player, itemstack);
            }
        } else if (!player.m_6144_()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.m_96637_()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ExchangingModes mode = ExchangingModes.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public static void rangeChange(Player player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingModes.GRID || range % 2 == 0 ? 1 : 2;
        range = player.m_6144_() ? (range <= 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.m_5661_((Component)MessageTranslation.RANGE_SET.componentTranslation(range).m_6270_(Styles.AQUA), true);
    }

    private void exchange(ServerPlayer player, ItemStack stack) {
        ServerLevel world = player.m_183503_();
        ItemStack heldItem = GadgetExchanger.getGadget((Player)player);
        if (heldItem.m_41619_()) {
            return;
        }
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)player, stack);
        BlockEntity tileEntity = world.m_7702_(lookingAt.m_82425_());
        BlockState lookingAtState = player.f_19853_.m_8055_(lookingAt.m_82425_());
        Block lookAtBlock = lookingAtState.m_60734_();
        if (blockData.getState() == Blocks.f_50016_.m_49966_() || lookAtBlock == OurBlocks.EFFECT_BLOCK.get() || blockData.getState() == lookingAtState || tileEntity != null) {
            return;
        }
        Optional<List<BlockPos>> anchor = GadgetUtils.getAnchor(stack);
        List coords = anchor.orElseGet(() -> GadgetExchanger.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext((Level)world, blockData.getState(), lookingAt.m_82425_(), heldItem, lookingAt.m_82434_(), GadgetExchanger.getConnectedArea(heldItem)), (Player)player));
        if (anchor.isPresent()) {
            GadgetUtils.setAnchor(stack);
        }
        IItemIndex index = InventoryHelper.index(stack, (Player)player);
        fakeWorld.setWorldAndState(player.f_19853_, blockData.getState(), coords);
        for (BlockPos coordinate : coords) {
            this.exchangeBlock(world, player, index, coordinate, blockData);
        }
    }

    private void exchangeBlock(ServerLevel world, ServerPlayer player, IItemIndex index, BlockPos pos, BlockData setBlock) {
        ITileEntityData data;
        BlockState currentBlock = world.m_8055_(pos);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            data = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getTileData();
            currentBlock = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getState();
        } else {
            data = TileSupport.createTileData((BlockGetter)world, pos);
        }
        ItemStack tool = GadgetExchanger.getGadget((Player)player);
        if (tool.m_41619_() || !this.canUse(tool, (Player)player)) {
            return;
        }
        BuildContext buildContext = BuildContext.builder().stack(tool).player((Player)player).build((LevelAccessor)world);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        boolean useConstructionPaste = false;
        if (!match.isSuccess()) {
            if (setBlock.getState().m_155947_()) {
                return;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return;
            }
            useConstructionPaste = true;
        }
        if (!player.m_36326_() || !world.m_7966_((Player)player, pos)) {
            return;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent((Level)world, pos, currentBlock, (Player)player);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP) || MinecraftForge.EVENT_BUS.post((Event)e)) {
            return;
        }
        this.applyDamage(tool, player);
        if (index.applyMatch(match)) {
            MaterialList materials = te instanceof ConstructionBlockTileEntity ? InventoryHelper.PASTE_LIST : data.getRequiredItems(buildContext, currentBlock, (HitResult)world.m_45547_(new ClipContext(player.m_20182_(), Vec3.m_82528_((Vec3i)pos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)), pos);
            PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> it = materials.iterator();
            LinkedHashMultiset producedItems = LinkedHashMultiset.create();
            if (buildContext.getStack().m_41793_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)buildContext.getStack()) > 0) {
                producedItems = it.hasNext() ? (Multiset)it.next() : ImmutableMultiset.of();
            } else {
                List drops = Block.m_49869_((BlockState)currentBlock, (ServerLevel)((ServerLevel)buildContext.getWorld()), (BlockPos)pos, (BlockEntity)buildContext.getWorld().m_7702_(pos));
                producedItems.addAll((Collection)drops.stream().map(UniqueItem::ofStack).collect(Collectors.toList()));
            }
            index.insert((Multiset<IUniqueObject<?>>)producedItems);
            EffectBlock.spawnEffectBlock((LevelAccessor)world, pos, setBlock, EffectBlock.Mode.REPLACE, useConstructionPaste);
        }
    }

    public static ItemStack getGadget(Player player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.m_41720_() instanceof GadgetExchanger)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    @Override
    public boolean performRotate(ItemStack stack, Player player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(ItemStack stack, Player player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

